/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SidedFluidInventory
extends FluidInventory {
    public boolean canExtract(int var1, FluidStack var2, class_2350 var3);

    public boolean canInsert(int var1, FluidStack var2, @Nullable class_2350 var3);

    @Override
    default public int count(FluidStack stack) {
        return this.count(stack, null);
    }

    @Override
    default public int count(FluidStack stack, class_2350 side) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.count(stack, maxAmount, side);
    }

    @Override
    default public int count(FluidStack stack, int maxAmount) {
        return this.count(stack, maxAmount, null);
    }

    @Override
    default public int count(FluidStack stack, int maxAmount, class_2350 side) {
        int amount = 0;
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack target;
            if (!this.canExtract(slot, stack, side) || (target = this.getStack(slot)).isEmpty() || !this.matches(target, stack) || (amount += target.getAmount()) < maxAmount) continue;
            return maxAmount;
        }
        return amount;
    }

    @Override
    default public FluidStack count(Predicate<FluidStack> predicate) {
        return this.count(predicate, null);
    }

    @Override
    default public FluidStack count(Predicate<FluidStack> predicate, class_2350 side) {
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack stack = this.getStack(slot);
            if (stack.isEmpty() || !this.canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            return this.onExtract(stack);
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public FluidStack count(Predicate<FluidStack> predicate, int maxAmount) {
        return this.count(predicate, maxAmount, null);
    }

    @Override
    default public FluidStack count(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int[] slots = this.getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            FluidStack findStack = this.getStack(i);
            if (findStack.isEmpty() || !this.canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount >= maxAmount) {
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                FluidStack stack = this.getStack(slot);
                if (!stack.isEmpty() && this.canExtract(slot, stack, side) && this.matches(stack, findStack) && (amount += stack.getAmount()) >= maxAmount) {
                    return this.onExtract(findStack.directCopy(maxAmount));
                }
                ++i;
            }
            return this.onExtract(findStack.directCopy(amount));
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public FluidStack countAny() {
        return this.countAny(null);
    }

    @Override
    default public FluidStack countAny(class_2350 side) {
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack target = this.getStack(slot);
            if (target.isEmpty() || !this.canExtract(slot, target, side)) continue;
            return this.onExtract(target.directCopy(target.getAmount()));
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public FluidStack countAny(int maxAmount) {
        return this.extractAny(maxAmount, null);
    }

    @Override
    default public FluidStack countAny(int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int[] slots = this.getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            FluidStack findStack = this.getStack(slot);
            if (findStack.isEmpty() || !this.canExtract(slot, findStack, side)) continue;
            int amount = findStack.getAmount();
            if (amount >= maxAmount) {
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            ++i;
            while (i < size) {
                slot = slots[i];
                FluidStack stack = this.getStack(slot);
                if (!stack.isEmpty() && this.canExtract(slot, stack, side) && this.matches(stack, findStack) && (amount += stack.getAmount()) >= maxAmount) {
                    return this.onExtract(findStack.directCopy(maxAmount));
                }
                ++i;
            }
            return this.onExtract(findStack.directCopy(amount));
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public int countSpace(FluidStack stack) {
        return this.countSpace(stack, null);
    }

    @Override
    default public int countSpace(FluidStack stack, class_2350 side) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.countSpace(stack, maxAmount, side);
    }

    @Override
    default public int countSpace(FluidStack stack, int maxAmount) {
        return this.countSpace(stack, maxAmount, null);
    }

    @Override
    default public int countSpace(FluidStack stack, int maxAmount, class_2350 side) {
        int amount = 0;
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack target;
            if (!this.canInsert(slot, stack, side) || !this.isValid(slot, stack) || !((target = this.getStack(slot)).isEmpty() ? (amount += this.getMaxAmount(stack)) >= maxAmount : this.matches(target, stack) && (amount += target.getMaxAmount() - target.getAmount()) >= maxAmount)) continue;
            return maxAmount;
        }
        return amount;
    }

    @Override
    default public boolean countSpace(List<FluidStack> stacks) {
        return this.countSpace(stacks, null);
    }

    @Override
    default public boolean countSpace(List<FluidStack> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            int amount;
            FluidStack stack = stacks.getFirst();
            return this.countSpace(stack, amount = stack.getAmount(), side) == amount;
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int amount;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            return this.countSpace(stack, amount = entry.getIntValue(), side) == amount;
        }
        block1: for (int slot : this.getAvailableSlots(side)) {
            FluidStack target = this.getStack(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.canInsert(slot, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.isValid(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxAmount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue block1;
                        return true;
                    }
                    entry.setValue(remaining - insert2);
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue block1;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxAmount - amount))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue block1;
                    return true;
                }
                entry.setValue(remaining - insert);
                continue block1;
            } while (iterator.hasNext());
        }
        return false;
    }

    @Override
    default public int extract(FluidStack stack) {
        return this.extract(stack, null);
    }

    @Override
    default public int extract(FluidStack stack, class_2350 side) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.extract(stack, maxAmount, side);
    }

    @Override
    default public int extract(FluidStack stack, int maxAmount) {
        return this.extract(stack, maxAmount, null);
    }

    @Override
    default public int extract(FluidStack stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack target;
            if (!this.canExtract(slot, stack, side) || (target = this.getStack(slot)).isEmpty() || !this.matches(target, stack)) continue;
            int amount = target.getAmount();
            if (amount > remaining) {
                target.setAmount(amount - remaining);
                this.markDirty();
                return maxAmount;
            }
            this.setStack(slot, FluidStack.EMPTY);
            if (amount == remaining) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= amount;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    @Override
    default public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount) {
        return this.extract(predicate, maxAmount, null);
    }

    @Override
    default public FluidStack extract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int[] slots = this.getAvailableSlots(side);
        int size = slots.length;
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            FluidStack findStack = this.getStack(slot);
            if (findStack.isEmpty() || !this.canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount > maxAmount) {
                findStack.setAmount(amount - maxAmount);
                this.markDirty();
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            this.setStack(slot, FluidStack.EMPTY);
            if (amount == maxAmount) {
                this.markDirty();
                return this.onExtract(findStack);
            }
            int remaining = maxAmount - amount;
            ++i;
            while (i < size) {
                slot = slots[i];
                FluidStack stack = this.getStack(slot);
                if (!stack.isEmpty() && this.canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    amount = stack.getAmount();
                    if (amount < remaining) {
                        this.setStack(slot, FluidStack.EMPTY);
                        remaining -= amount;
                    } else {
                        if (amount == remaining) {
                            this.setStack(slot, FluidStack.EMPTY);
                        } else {
                            stack.setAmount(amount - remaining);
                        }
                        this.markDirty();
                        findStack.setAmount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
            this.markDirty();
            findStack.setAmount(maxAmount - remaining);
            return this.onExtract(findStack);
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public FluidStack extract(Predicate<FluidStack> predicate) {
        return this.extract(predicate, null);
    }

    @Override
    default public FluidStack extract(Predicate<FluidStack> predicate, class_2350 side) {
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack stack = this.getStack(slot);
            if (stack.isEmpty() || !this.canExtract(slot, stack, side) || !predicate.test(stack)) continue;
            this.setStack(slot, FluidStack.EMPTY);
            this.markDirty();
            return this.onExtract(stack);
        }
        return FluidStack.EMPTY;
    }

    public int[] getAvailableSlots(@Nullable class_2350 var1);

    @Override
    default public int insert(FluidStack stack) {
        return this.insert(stack, null);
    }

    @Override
    default public int insert(FluidStack stack, int maxAmount) {
        return this.insert(stack, maxAmount, null);
    }

    @Override
    default public int insert(FluidStack stack, class_2350 side) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return 0;
        }
        return this.insert(stack, maxAmount, side);
    }

    @Override
    default public int insert(FluidStack stack, int maxAmount, class_2350 side) {
        int remaining = maxAmount;
        for (int slot : this.getAvailableSlots(side)) {
            if (!this.canInsert(slot, stack, side) || !this.isValid(slot, stack)) continue;
            FluidStack target = this.getStack(slot);
            if (target.isEmpty()) {
                int insert = Math.min(remaining, this.getMaxAmount(stack));
                this.setStack(slot, stack.directCopy(insert));
                if (remaining == insert) {
                    this.markDirty();
                    return maxAmount;
                }
                remaining -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(remaining, maxCount - amount);
            target.setAmount(amount + insert);
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    @Override
    default public List<FluidStack> insert(List<FluidStack> stacks) {
        return this.insert(stacks, null);
    }

    @Override
    default public List<FluidStack> insert(List<FluidStack> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return stacks;
        }
        if (listSize == 1) {
            int insert;
            FluidStack stack = stacks.getFirst();
            int amount = stack.getAmount();
            if (amount == (insert = this.insert(stack, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            int insert;
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            FluidStack stack = (FluidStack)entry.getKey();
            int amount = entry.getIntValue();
            if (amount == (insert = this.insert(stack, amount, side))) {
                return List.of();
            }
            if (insert == 0) {
                return stacks;
            }
            return List.of(stack.directCopy(amount - insert));
        }
        boolean dirty = false;
        block1: for (int slot : this.getAvailableSlots(side)) {
            FluidStack target = this.getStack(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.canInsert(slot, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.isValid(slot, stack)) continue;
                if (empty) {
                    int remaining = entry.getIntValue();
                    int insert = Math.min(remaining, this.getMaxAmount(stack));
                    this.setStack(slot, stack.directCopy(insert));
                    if (remaining == insert) {
                        iterator.remove();
                        if (entries.isEmpty()) {
                            this.markDirty();
                            return List.of();
                        }
                    } else {
                        entry.setValue(remaining - insert);
                    }
                    dirty = true;
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue block1;
                int remaining = entry.getIntValue();
                int insert = Math.min(remaining, maxAmount - amount);
                target.setAmount(amount + insert);
                if (remaining == insert) {
                    iterator.remove();
                    if (entries.isEmpty()) {
                        this.markDirty();
                        return List.of();
                    }
                } else {
                    entry.setValue(remaining - insert);
                }
                dirty = true;
                continue block1;
            } while (iterator.hasNext());
        }
        if (dirty) {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>(entries.size());
            for (Object2IntMap.Entry entry : entries) {
                FluidStack stack = (FluidStack)entry.getKey();
                int amount = entry.getIntValue();
                if (stack.getAmount() == amount) {
                    result.add(stack);
                    continue;
                }
                result.add(stack.directCopy(amount));
            }
            this.markDirty();
            return result;
        }
        return stacks;
    }

    @Override
    default public int insertExist(FluidStack stack) {
        return this.insertExist(stack, null);
    }

    @Override
    default public int insertExist(FluidStack stack, class_2350 side) {
        int maxAmount;
        if (stack.isEmpty()) {
            return 0;
        }
        int remaining = maxAmount = stack.getAmount();
        ArrayList<Integer> emptys = new ArrayList<Integer>();
        for (int slot : this.getAvailableSlots(side)) {
            if (!this.canInsert(slot, stack, side) || !this.isValid(slot, stack)) continue;
            FluidStack target = this.getStack(slot);
            if (target.isEmpty()) {
                emptys.add(slot);
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(remaining, maxCount - amount);
            target.setAmount(amount + insert);
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        Object object = emptys.iterator();
        while (object.hasNext()) {
            int slot = (Integer)object.next();
            int insert = Math.min(remaining, this.getMaxAmount(stack));
            this.setStack(slot, stack.directCopy(insert));
            if (remaining == insert) {
                this.markDirty();
                return maxAmount;
            }
            remaining -= insert;
        }
        if (remaining == maxAmount) {
            return 0;
        }
        this.markDirty();
        return maxAmount - remaining;
    }

    @Override
    @NotNull
    default public java.util.Iterator<FluidStack> iterator() {
        return this.iterator(null);
    }

    @Override
    @NotNull
    default public java.util.Iterator<FluidStack> iterator(class_2350 side) {
        return new Iterator(this, side);
    }

    @Override
    default public boolean preciseExtract(FluidStack stack) {
        return this.preciseExtract(stack, null);
    }

    @Override
    default public boolean preciseExtract(FluidStack stack, class_2350 side) {
        if (stack.isEmpty()) {
            return true;
        }
        int remaining = stack.getAmount();
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.getAvailableSlots(side)) {
            FluidStack target;
            if (!this.canExtract(slot, stack, side) || (target = this.getStack(slot)).isEmpty() || !this.matches(target, stack)) continue;
            int amount = target.getAmount();
            if (amount > remaining) {
                changes.forEach(Runnable::run);
                target.setAmount(amount - remaining);
                this.markDirty();
                return true;
            }
            if (amount == remaining) {
                changes.forEach(Runnable::run);
                this.setStack(slot, FluidStack.EMPTY);
                this.markDirty();
                return true;
            }
            changes.add(() -> this.setStack(slot, FluidStack.EMPTY));
            remaining -= amount;
        }
        return false;
    }

    @Override
    default public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount) {
        return this.preciseExtract(predicate, maxAmount, null);
    }

    @Override
    default public FluidStack preciseExtract(Predicate<FluidStack> predicate, int maxAmount, class_2350 side) {
        if (maxAmount == 0) {
            return FluidStack.EMPTY;
        }
        int[] slots = this.getAvailableSlots(side);
        int size = slots.length;
        ArrayList<Integer> buffer = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            int slot = slots[i];
            FluidStack findStack = this.getStack(slot);
            if (findStack.isEmpty() || !this.canExtract(slot, findStack, side) || !predicate.test(findStack)) continue;
            int amount = findStack.getAmount();
            if (amount > maxAmount) {
                findStack.setAmount(amount - maxAmount);
                this.markDirty();
                return this.onExtract(findStack.directCopy(maxAmount));
            }
            if (amount == maxAmount) {
                this.setStack(slot, FluidStack.EMPTY);
                this.markDirty();
                return this.onExtract(findStack);
            }
            buffer.add(slot);
            int remaining = maxAmount - amount;
            ++i;
            while (i < size) {
                slot = slots[i];
                FluidStack stack = this.getStack(slot);
                if (!stack.isEmpty() && this.canExtract(slot, stack, side) && this.matches(stack, findStack)) {
                    amount = stack.getAmount();
                    if (amount < remaining) {
                        buffer.add(slot);
                        remaining -= amount;
                    } else {
                        buffer.forEach(j -> this.setStack((int)j, FluidStack.EMPTY));
                        if (amount == remaining) {
                            this.setStack(slot, FluidStack.EMPTY);
                        } else {
                            stack.setAmount(amount - remaining);
                        }
                        this.markDirty();
                        findStack.setAmount(maxAmount);
                        return this.onExtract(findStack);
                    }
                }
                ++i;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    default public boolean preciseInsert(FluidStack stack) {
        return this.preciseInsert(stack, null);
    }

    @Override
    default public boolean preciseInsert(FluidStack stack, class_2350 side) {
        int maxAmount = stack.getAmount();
        if (maxAmount == 0) {
            return true;
        }
        return this.preciseInsert(stack, maxAmount, side);
    }

    @Override
    default public boolean preciseInsert(FluidStack stack, int maxAmount) {
        return this.preciseInsert(stack, maxAmount, null);
    }

    @Override
    default public boolean preciseInsert(FluidStack stack, int maxAmount, class_2350 side) {
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        for (int slot : this.getAvailableSlots(side)) {
            if (!this.canInsert(slot, stack, side) || !this.isValid(slot, stack)) continue;
            FluidStack target = this.getStack(slot);
            if (target.isEmpty()) {
                int insert = Math.min(maxAmount, this.getMaxAmount(stack));
                if (maxAmount == insert) {
                    changes.forEach(Runnable::run);
                    this.setStack(slot, stack.directCopy(insert));
                    this.markDirty();
                    return true;
                }
                changes.add(() -> this.setStack(slot, stack.directCopy(insert)));
                maxAmount -= insert;
                continue;
            }
            if (!this.matches(target, stack)) continue;
            int maxCount = target.getMaxAmount();
            int amount = target.getAmount();
            if (amount == maxCount) continue;
            int insert = Math.min(maxAmount, maxCount - amount);
            if (maxAmount == insert) {
                changes.forEach(Runnable::run);
                target.setAmount(amount + insert);
                this.markDirty();
                return true;
            }
            changes.add(() -> target.setAmount(amount + insert));
            maxAmount -= insert;
        }
        return false;
    }

    @Override
    default public boolean preciseInsert(List<FluidStack> stacks) {
        return this.preciseInsert(stacks, null);
    }

    @Override
    default public boolean preciseInsert(List<FluidStack> stacks, class_2350 side) {
        int listSize = stacks.size();
        if (listSize == 0) {
            return true;
        }
        if (listSize == 1) {
            return this.preciseInsert(stacks.getFirst(), side);
        }
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap(FLUID_STACK_HASH_STRATEGY);
        for (FluidStack stack : stacks) {
            map.merge((Object)stack, stack.getAmount(), Integer::sum);
        }
        Object2IntSortedMap.FastSortedEntrySet entries = map.object2IntEntrySet();
        if (entries.size() == 1) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)entries.first();
            return this.preciseInsert((FluidStack)entry.getKey(), entry.getIntValue(), side);
        }
        ArrayList<Runnable> changes = new ArrayList<Runnable>();
        block1: for (int slot : this.getAvailableSlots(side)) {
            FluidStack target = this.getStack(slot);
            boolean empty = target.isEmpty();
            ObjectBidirectionalIterator iterator = entries.fastIterator();
            do {
                int insert;
                Object2IntMap.Entry entry;
                FluidStack stack;
                if (!this.canInsert(slot, stack = (FluidStack)(entry = (Object2IntMap.Entry)iterator.next()).getKey(), side) || !this.isValid(slot, stack)) continue;
                if (empty) {
                    int insert2;
                    int remaining = entry.getIntValue();
                    if (remaining == (insert2 = Math.min(remaining, this.getMaxAmount(stack)))) {
                        iterator.remove();
                        if (!entries.isEmpty()) continue block1;
                        changes.forEach(Runnable::run);
                        this.setStack(slot, stack.directCopy(insert2));
                        this.markDirty();
                        return true;
                    }
                    changes.add(() -> this.setStack(slot, stack.directCopy(insert2)));
                    entry.setValue(remaining - insert2);
                    continue block1;
                }
                if (!this.matches(target, stack)) continue;
                int maxAmount = target.getMaxAmount();
                int amount = target.getAmount();
                if (amount == maxAmount) continue block1;
                int remaining = entry.getIntValue();
                if (remaining == (insert = Math.min(remaining, maxAmount - amount))) {
                    iterator.remove();
                    if (!entries.isEmpty()) continue block1;
                    changes.forEach(Runnable::run);
                    target.setAmount(amount + insert);
                    this.markDirty();
                    return true;
                }
                changes.add(() -> target.setAmount(amount + insert));
                entry.setValue(remaining - insert);
                continue block1;
            } while (iterator.hasNext());
        }
        return false;
    }

    public static class Iterator
    implements java.util.Iterator<FluidStack> {
        private final SidedFluidInventory inventory;
        private final class_2350 side;
        private final int[] slots;
        private int index;
        private int current = -1;

        public Iterator(SidedFluidInventory inventory, class_2350 side) {
            this.inventory = inventory;
            this.side = side;
            this.slots = inventory.getAvailableSlots(side);
        }

        @Override
        public boolean hasNext() {
            if (this.current >= 0) {
                return true;
            }
            if (this.current == -2) {
                return false;
            }
            while (this.index < this.slots.length) {
                FluidStack stack = this.inventory.getStack(this.slots[this.index]);
                if (this.inventory.canExtract(this.index, stack, this.side)) {
                    this.current = this.index++;
                    return true;
                }
                ++this.index;
            }
            this.current = -2;
            return false;
        }

        @Override
        public FluidStack next() {
            if (this.hasNext()) {
                FluidStack result = this.inventory.getStack(this.slots[this.current]);
                this.current = -1;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

